#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"
#include "../scorpion.h"

#define FOND_Z (1.f)

static GrVertex Fond1 = {450.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {550.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {550.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {450,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond5 = {0.f,337.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond6 = {640.f,337,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond7 = {640.,412.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond8 = {0,412.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Come1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Come2 = {256.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Come3 = {256.,85.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,85.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Come4 = {0,85.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,85.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Come5 = {0.f,85.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,85, 1.f/FOND_Z}};
static GrVertex Come6 = {256.f,85,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,85,1.f/300.f}};
static GrVertex Come7 = {256.,170.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,170.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Come8 = {0,170.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,170.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Come9 = {0.f,170.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,170, 1.f/FOND_Z}};
static GrVertex Come10 = {256.f,170,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,170,1.f/300.f}};
static GrVertex Come11 = {256.,256.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Come12 = {0,256.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static Obj3d *pTorus, *pTorus2, *pTorus3, *pTorus4;
static float Matrix[16], Matrix2[16];
static float GouraudMatrix[16];
static float GouraudMatrix2[16];

static Obj3d Duck;

static DWORD bComeGetSome = FALSE;

void LInit_Tunn3d()
{
	FILE *file;
	DWORD dwDummy;
	DWORD Cpt1;
	unsigned short A,B,C;
	float fTmp;

  //pTorus = GenerateTorus(90, 20, 500, 50);
  pTorus = GenerateTorus(90, 20, 500, 15);
  ComputeGouraud(pTorus);
  PrepareTextureFromArray(g_PicTunn3d, 256, 256, &g_TextureTunn3d);

	file = fopen(PackageName, "rb");
	SeekToSubfile(file, CANARD, &dwDummy);
	fread(&Duck.NbVertex, 4, 1, file);
	Duck.pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*Duck.NbVertex);
	Duck.pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*Duck.NbVertex);
	for(Cpt1=0;Cpt1<Duck.NbVertex;Cpt1++)
	{
		fread(&Duck.pVertexIn[Cpt1].x, 4, 1, file);
		fread(&Duck.pVertexIn[Cpt1].y, 4, 1, file);
		fread(&Duck.pVertexIn[Cpt1].z, 4, 1, file);
		fread(&Duck.pVertexIn[Cpt1].tmuvtx[0].sow, 4, 1, file);
		fread(&Duck.pVertexIn[Cpt1].tmuvtx[0].tow, 4, 1, file);
		Duck.pVertexOut[Cpt1].a = 0.f;
	}
	fread(&Duck.NbFaces, 4, 1, file);
	Duck.pFace = (Face*)malloc(sizeof(Face)*Duck.NbFaces);
	for(Cpt1=0;Cpt1<Duck.NbFaces;Cpt1++)
	{
		fread(&A, 2, 1, file);
		fread(&B, 2, 1, file);
		fread(&C, 2, 1, file);
		Duck.pFace[Cpt1].A = A;
		Duck.pFace[Cpt1].B = B;
		Duck.pFace[Cpt1].C = C;
	}
	fclose(file);

  //LoadObject(&Duck, duckvtx, duckface);

	ComputeGouraud(&Duck);
	for(Cpt1=0;Cpt1<Duck.NbVertex;Cpt1++)
	{
		fTmp = Duck.pVertexIn[Cpt1].zNorm * -255.f;
		Duck.pVertexOut[Cpt1].r = Duck.pVertexOut[Cpt1].g = Duck.pVertexOut[Cpt1].b =
			( fTmp*2< 0)?0:fTmp*2>255.f?255.f:fTmp*2;
			
	}
}

void QInit_Tunn3d()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_POSITIVE);

	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0x33aa33);
	//grFogColorValue(0x3333aa);
	//grFogColorValue(0xaa3333);
	grFogTable(g_FogTunnel);

	DownloadTexture(&g_TextureTunn3d);

	grConstantColorValue(128<<24);
	g_demostate.ClearColor = 0;
}

void Effect_Tunn3d()
{
	int Img1;

	Img1 = g_demostate.TickInEffect/16;

	//Nega = ((g_demostate.TickInEffect>>11)&1)&((g_demostate.TickInEffect>>6)&1);

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	if (
		((g_demostate.midas_status.position==9)||(g_demostate.midas_status.position==17))
		&&(g_demostate.TickInPattern>4500))
	{
		DWORD dwTmp;
		DWORD dwTmpFog1, dwTmpFog2;
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_LOCAL,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp = (5000-g_demostate.TickInPattern)*256/500;
		dwTmp = CLIP_DW(dwTmp);
		grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
		dwTmpFog1 = 0x33*(5000-g_demostate.TickInPattern)/500;
		dwTmpFog1 = CLIP_DW(dwTmpFog1);
		dwTmpFog2 = 0xaa*(5000-g_demostate.TickInPattern)/500;
		dwTmpFog2 = CLIP_DW(dwTmpFog2);
		grFogColorValue((dwTmpFog1<<16)|(dwTmpFog2<<8)|dwTmpFog1);
	}
	else
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	}
	BeIdentityMatrix(Matrix);
//	TranslateMatrix(Matrix,500*(float)sin(Img1/120.f),
//		13*(float)cos(Img1/30.f),500*(float)cos(Img1/120.f));

	TranslateMatrix(Matrix,500*SinTable[g_demostate.TickInEffect&8191],
		0,500*CosTable[g_demostate.TickInEffect&8191]);
	
	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect*3/2);
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect*3/2);
	RotateZMatrix(Matrix2, Matrix, g_demostate.TickInEffect*3/2);
	//RotateYMatrix(Matrix2, Matrix, -g_demostate.TickInEffect+2048);
	/*ScaleMatrix(Matrix2,
		1.f+0.8f*CosTable[g_demostate.TickInEffect&8191],
		1.f+0.8f*CosTable[(g_demostate.TickInEffect+2730)&8191],
		0.6f+0.4f*CosTable[(g_demostate.TickInEffect+5460)&8191]);*/

	SelectTexture(g_TextureTunn3d);
	DrawWithMatrix(pTorus, Matrix2, FALSE, GouraudMatrix2, 0);

	// 2 rectangles
	/*grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					//GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_NONE, Nega);
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_NONE, FALSE);

	grDrawTriangle(&Fond1, &Fond3, &Fond2);
	grDrawTriangle(&Fond3, &Fond1, &Fond4);

	grDrawTriangle(&Fond5, &Fond7, &Fond6);
	grDrawTriangle(&Fond7, &Fond5, &Fond8);*/

	if (g_demostate.midas_status.position==9)
	{
		grFogMode(GR_FOG_DISABLE);
		grDepthBufferFunction(GR_CMP_ALWAYS);
		grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_NONE, FALSE);
		grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
		grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
								GR_BLEND_ONE, GR_BLEND_ZERO);
		BeIdentityMatrix(Matrix);
		BeIdentityMatrix(GouraudMatrix);
		RotateXMatrix(Matrix2, Matrix, 2048);
		RotateYMatrix(Matrix, Matrix2, -(int)g_demostate.TickInPattern*2+1024);
		//RotateYMatrix(GouraudMatrix2, GouraudMatrix, g_demostate.TickInPattern*2+1024);
		//ScaleMatrix(Matrix, 1,1, SinTable[(g_demostate.TickInPattern*2+3333)&8191]+2.f);
		TranslateMatrix(Matrix, (float)g_demostate.TickInPattern*3-8000, 0, 4000);
		DrawWithMatrix(&Duck, Matrix, FALSE, GouraudMatrix2, 0);
		grDepthBufferFunction(GR_CMP_LESS);
		grFogMode(GR_FOG_WITH_TABLE);
	}
	else
	{
		/*if (g_demostate.midas_status.position>=16)
		{
			DWORD dwTmp, dwFlash;

			SelectTexture(g_TextureComegetsome);
			dwTmp = g_demostate.TickInEffect*16/5000;
			dwFlash = (g_demostate.TickInEffect%(5000/16))*256*16/5000;
			dwFlash = CLIP_DW(dwFlash);
			dwFlash = dwFlash|(dwFlash<<8)|(dwFlash<<16);
			grConstantColorValue(dwFlash);
			grAlphaBlendFunction(GR_BLEND_ONE_MINUS_DST_COLOR, GR_BLEND_ONE_MINUS_SRC_COLOR,
				GR_BLEND_ONE, GR_BLEND_ZERO);
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_LOCAL,
				GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			grFogMode(GR_FOG_DISABLE);
			grCullMode(GR_CULL_DISABLE);
			switch(dwTmp%4)
			{
			case 0:
				grDrawTriangle(&Come3,&Come2,&Come1);
				grDrawTriangle(&Come3,&Come4,&Come1);
				break;
			case 1:
				grDrawTriangle(&Come5,&Come6,&Come7);
				grDrawTriangle(&Come7,&Come8,&Come5);
				break;
			case 2:
				grDrawTriangle(&Come9,&Come10,&Come11);
				grDrawTriangle(&Come11,&Come12,&Come9);
				break;
			case 3:
				break;
			}
			grFogMode(GR_FOG_WITH_TABLE);
			grCullMode(GR_CULL_POSITIVE);
		}*/
	}
}

void ByeBye_Tunn3d()
{
	FreeTexture(&g_TextureTunn3d);
}
